@extends('admin.layout.page-app')
@section('page_title', __('label.edit_quiz_configuration'))
@section('tab_title', __('label.edit_quiz_configuration'))

@section('content')
	@include('admin.layout.sidebar')

	<div class="right-content">
		@include('admin.layout.header')

  		<div class="body-content">
  			<!-- mobile title -->
  			<h1 class="page-title-sm">{{__('label.edit_quiz_configuration')}}</h1>

  			<div class="border-bottom row">
  				<div class="col-sm-10">
  					<ol class="breadcrumb">
  						<li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{__('label.dashboard')}}</a></li>
  						<li class="breadcrumb-item"><a href="{{ route('admin.quizconfiguration.index') }}">{{__('label.quiz_configuration')}}</a></li>
  						<li class="breadcrumb-item active" aria-current="page">{{__('label.edit_quiz_configuration')}}</li>
  					</ol>
  				</div>
  				<div class="col-sm-2 d-flex align-items-center justify-content-end">
  					<a href="{{ route('admin.quizconfiguration.index') }}" class="btn btn-default mw-120" style="margin-top:-14px">{{__('label.quiz_configuration')}}</a>
  				</div>
  			</div>

  			<div class="card custom-border-card mt-3">
  				<form id="edit_quiz_configuration" enctype="multipart/form-data">
				  	<input type="hidden" name="id" value="{{ $result['id'] }}">
					<div class="form-row">
						<!-- Category Status -->
						@if(in_array($result['id'], [1, 2, 3, 4, 5, 6]))
							<div class="col-xl-2 col-md-3">
								<div class="form-group">
									<label>{{__('label.category')}}<span class="text-danger">*</span></label>
									<div class="radio-group">
										<div class="custom-control custom-radio">
											<input type="radio" name="category_status" id="category_status_show" class="custom-control-input" {{ $result['category_status'] == 1 ? "checked" : "" }} value="1" onchange="toggleBadge('category', this.value)">
											<label class="custom-control-label" for="category_status_show">{{__('label.show')}}</label>
										</div>
										<div class="custom-control custom-radio">
											<input type="radio" name="category_status" id="category_status_hide" class="custom-control-input" {{ $result['category_status'] == 0 ? "checked" : "" }} value="0" onchange="toggleBadge('category', this.value)">
											<label class="custom-control-label" for="category_status_hide">{{__('label.hide')}}</label>
										</div>
									</div>
								</div>
							</div>
						@endif

						<!-- Skill Status -->
						@if(in_array($result['id'], [1, 2, 3, 4, 5, 6]))
							<div class="col-xl-2 col-md-3">
								<div class="form-group">
									<label>{{__('label.skill')}}<span class="text-danger">*</span></label>
									<div class="radio-group">
										<div class="custom-control custom-radio">
											<input type="radio" name="skill_status" id="skill_status_show" class="custom-control-input" {{ $result['skill_status'] == 1 ? "checked" : "" }} value="1" onchange="toggleBadge('skill', this.value)">
											<label class="custom-control-label" for="skill_status_show">{{__('label.show')}}</label>
										</div>
										<div class="custom-control custom-radio">
											<input type="radio" name="skill_status" id="skill_status_hide" class="custom-control-input" {{ $result['skill_status'] == 0 ? "checked" : "" }} value="0" onchange="toggleBadge('skill', this.value)">
											<label class="custom-control-label" for="skill_status_hide">{{__('label.hide')}}</label>
										</div>
									</div>
								</div>
							</div>
						@endif

						<!-- Classification Status -->
						@if(in_array($result['id'], [1, 2, 3, 4, 5, 6]))
							<div class="col-xl-2 col-md-3">
								<div class="form-group">
									<label>{{__('label.classification')}}<span class="text-danger">*</span></label>
									<div class="radio-group">
										<div class="custom-control custom-radio">
											<input type="radio" name="classification_status" id="classification_status_show" class="custom-control-input" {{ $result['classification_status'] == 1 ? "checked" : "" }} value="1" onchange="toggleBadge('classification', this.value)">
											<label class="custom-control-label" for="classification_status_show">{{__('label.show')}}</label>
										</div>
										<div class="custom-control custom-radio">
											<input type="radio" name="classification_status" id="classification_status_no" class="custom-control-input" {{ $result['classification_status'] == 0 ? "checked" : "" }} value="0" onchange="toggleBadge('classification', this.value)">
											<label class="custom-control-label" for="classification_status_no">{{__('label.hide')}}</label>
										</div>
									</div>
								</div>
							</div>
						@endif

						<!-- Level Status -->
						@if(in_array($result['id'], [1, 2, 3, 4, 5, 6]))
							<div class="col-xl-2 col-md-3">
								<div class="form-group">
									<label>{{__('label.level')}}<span class="text-danger">*</span></label>
									<div class="radio-group">
										<div class="custom-control custom-radio">
											<input type="radio" name="level_status" id="level_status_show" class="custom-control-input" {{ $result['level_status'] == 1 ? "checked" : "" }} value="1" onchange="toggleBadge('level', this.value)">
											<label class="custom-control-label" for="level_status_show">{{__('label.show')}}</label>
										</div>
										<div class="custom-control custom-radio">
											<input type="radio" name="level_status" id="level_status_hide" class="custom-control-input" {{ $result['level_status'] == 0 ? "checked" : "" }} value="0" onchange="toggleBadge('level', this.value)">
											<label class="custom-control-label" for="level_status_hide">{{__('label.hide')}}</label>
										</div>
									</div>
								</div>
							</div>
						@endif
					</div>
					<!-- Quiz Sort Order  -->
					@if(in_array($result['id'], [1, 2, 3, 4, 5, 6]))
						<div class="form-row">
							<div class="col-12">
								<div class="form-group">
									<label>{{__('label.flow_sort_order')}}<span class="text-danger">*</span></label>
									<div class="row gx-2 gy-2 align-items-center flow-sort-order-card text-center m-0">
										<div class="col-auto">
											<div class="badge not-draggable w-100">{{ __('label.start') }}</div>
										</div>
										
										<div class="col-auto"><i class="fa-solid fa-arrow-right-long"></i></div>

										<div class="col flex-grow-1">
											<div id="sortList" class="d-flex flex-wrap justify-content-center gap-2">
												<?php
													$fields = ['1' => __('label.category'), '2' => __('label.skill'), '3' => __('label.classification'), '4' => __('label.level')];
													$badgeIds = ['1' => 'badge_category', '2' => 'badge_skill', '3' => 'badge_classification', '4' => 'badge_level'];
													$order = isset($result['quiz_sort_order']) && $result['quiz_sort_order'] ? explode(',', $result['quiz_sort_order']) : ['1', '2', '3', '4'];
												?>

												@foreach($order as $id)
													<div class="sortable-item badge" data-id="{{ $id }}" id="{{ $badgeIds[$id] ?? '' }}">
														{{ $fields[$id] ?? '-' }}
													</div>
												@endforeach
											</div>
										</div>

										<div class="col-auto"><i class="fa-solid fa-arrow-right-long"></i></div>

										<div class="col-auto">
											<div class="badge not-draggable w-100">{{ __('label.play') }}</div>
										</div>
									</div>

									<input type="hidden" name="quiz_sort_order" id="quiz_sort_order">
								</div>
							</div>
						</div>
					@endif
					<div class="form-row mt-3">
						<!-- Total Question -->
						@if(in_array($result['id'], [1, 2, 3, 4, 5, 6, 9]))
							<div class="col-md-2">
								<div class="form-group">
									<label>{{__('label.total_questions')}}<span class="text-danger">*</span></label>
									<input type="number" name="total_questions" min="1" value="{{ $result['total_questions'] }}" class="form-control" placeholder="{{__('label.total_questions_here')}}">
								</div>
							</div>
						@endif

						<!-- Quiz Duration -->
						@if(in_array($result['id'], [1, 2, 3, 4, 5, 6, 9]))
							<div class="col-md-2">
								<div class="form-group">
									<label>{{__('label.duration_per_question')}}<span class="text-danger">*</span></label>
									<input type="number" name="quiz_duration" min="1" value="{{ $result['quiz_duration'] }}" class="form-control" placeholder="{{__('label.seconds_here')}}">
								</div>
							</div>					
						@endif

						<!-- Min Winning Percentage -->
						@if(in_array($result['id'], [1, 2, 3, 4, 5, 6, 9]))
							<div class="col-md-2">
								<div class="form-group">
									<label>{{__('label.min_winning_percentage')}}<span class="text-danger">*</span></label>
									<input type="number" name="min_winning_percentage" min="0" value="{{ $result['min_winning_percentage'] }}" class="form-control" placeholder="{{__('label.percentage_here')}}">
								</div>
							</div>
						@endif

						<!-- Winning Coin -->
						@if(in_array($result['id'], [2, 3, 4, 5, 6, 9]))
							<div class="col-md-2">
								<div class="form-group">
									<label>{{__('label.winning_coin')}}<span class="text-danger">*</span></label>
									<input type="number" name="winning_coin" min="0" value="{{ $result['winning_coin'] }}" class="form-control" placeholder="{{__('label.coin_here')}}">
								</div>
							</div>
						@endif

						<!-- Winning Coin Type -->
						@if(in_array($result['id'], [2, 3, 4, 5, 6]))
							<div class="col-md-3">
								<div class="form-group">
									<label>{{__('label.winning_coin_type')}}<span class="text-danger">*</span></label>
									<div class="radio-group">
										<div class="custom-control custom-radio">
											<input type="radio" name="winning_coin_type" id="winning_coin_type_one" class="custom-control-input" {{ $result['winning_coin_type'] == 1 ? "checked" : "" }} value="1">
											<label class="custom-control-label" for="winning_coin_type_one">{{__('label.one_time')}}</label>
										</div>
										<div class="custom-control custom-radio">
											<input type="radio" name="winning_coin_type" id="winning_coin_type_every" class="custom-control-input" {{ $result['winning_coin_type'] == 2 ? "checked" : "" }} value="2">
											<label class="custom-control-label" for="winning_coin_type_every">{{__('label.every_time')}}</label>
										</div>
									</div>
								</div>
							</div>
						@endif
					</div>
					<div class="form-row">
						<!-- Joining Type -->
						@if(in_array($result['id'], [2, 3, 4, 5, 6]))
							<div class="col-md-3">
								<div class="form-group">
									<label>{{__('label.joining_type')}}<span class="text-danger">*</span></label>
									<div class="radio-group">
										<div class="custom-control custom-radio">
											<input type="radio" name="joining_type" id="joining_type_level" class="custom-control-input" {{ $result['joining_type'] == 1 ? "checked" : "" }} value="1" onchange="toggleJoiningType(this.value)">
											<label class="custom-control-label" for="joining_type_level">{{__('label.level_wise')}}</label>
										</div>
										<div class="custom-control custom-radio">
											<input type="radio" name="joining_type" id="joining_type_quiz" class="custom-control-input" {{ $result['joining_type'] == 2 ? "checked" : "" }} value="2" onchange="toggleJoiningType(this.value)">
											<label class="custom-control-label" for="joining_type_quiz">{{__('label.quiz_wise')}}</label>
										</div>
									</div>
								</div>
							</div>
						@endif

						<!-- Joining Coin -->
						@if(in_array($result['id'], [2, 3, 4, 5, 6, 9]))
							<div class="col-md-2" id="joining_coin">
								<div class="form-row">
									<div class="form-group">
										<label>{{__('label.joining_coin')}}<span class="text-danger">*</span></label>
										<input type="number" name="joining_coin" min="1" value="{{ $result['joining_coin'] }}" class="form-control" placeholder="{{__('label.coin_here')}}">
									</div>
								</div>
							</div>
						@endif

						<!-- Battles Commission -->
						@if(in_array($result['id'], [10, 11]))
							<div class="col-md-2">
								<div class="form-row">
									<div class="form-group">
										<label>{{__('label.battles_commission')}} ( % )<span class="text-danger">*</span></label>
										<input type="number" name="battles_commission" min="0" max="100" value="{{ $result['battles_commission'] }}" class="form-control" placeholder="{{__('label.percentage_here')}}">
									</div>
								</div>
							</div>
						@endif

						<!-- Min User Join -->
						@if(in_array($result['id'], [11]))
							<div class="col-md-2">
								<div class="form-row">
									<div class="form-group">
										<label>{{__('label.min_user_join')}}<span class="text-danger">*</span></label>
										<input type="number" name="min_user_join" min="3" value="{{ $result['min_user_join'] }}" class="form-control" placeholder="{{__('label.min_user_here')}}">
									</div>
								</div>
							</div>
						@endif

						<!-- Max User Join -->
						@if(in_array($result['id'], [11]))
							<div class="col-md-2">
								<div class="form-row">
									<div class="form-group">
										<label>{{__('label.max_user_join')}}<span class="text-danger">*</span></label>
										<input type="number" name="max_user_join" min="3" value="{{ $result['max_user_join'] }}" class="form-control" placeholder="{{__('label.max_user_here')}}">
									</div>
								</div>
							</div>
						@endif
					</div>
  					<div class="border-top pt-3 text-right">
  						<button type="button" class="btn btn-default mw-120" onclick="edit_quiz_configuration()">{{__('label.update')}}</button>
						<a href="{{ route('admin.quizconfiguration.index') }}" class="btn btn-cancel mw-120 ml-2">{{__('label.cancel')}}</a>
						<input type="hidden" name="_method" value="PATCH">
  					</div>
  				</form>
  			</div>
		</div>
  	</div>		
@endsection

@section('pagescript')
    <!-- Sortorder -->
	<script src="https://cdn.jsdelivr.net/npm/sortablejs@1.15.0/Sortable.min.js"></script>

	<script>
		function toggleBadge(type, value) {
			const badgeId = `badge_${type}`;
			const badge = document.getElementById(badgeId);
			
			if (badge) {
				if (value === '0') {
					badge.style.display = 'none'; // Hide badge
				} else {
					badge.style.display = 'inline-block'; // Show badge
				}
			}
		}
		function toggleJoiningType(value) {
			if (value === '1') {
				$('#joining_coin').hide();
			} else {
				$('#joining_coin').show();
			}
		}
		document.addEventListener('DOMContentLoaded', function () {
			['category', 'skill', 'level', 'classification'].forEach(type => {
				const selected = document.querySelector(`input[name="${type}_status"]:checked`);
				if (selected) toggleBadge(type, selected.value);
			});

			const selected = document.querySelector('input[name="joining_type"]:checked');
			if (selected) {
				toggleJoiningType(selected.value);
			}
		});

    	document.addEventListener('DOMContentLoaded', function () {
        	const sortList = document.getElementById('sortList');
			const hiddenInput = document.getElementById('quiz_sort_order');

			Sortable.create(sortList, {
				animation: 300,
				onSort: function () {
					const order = Array.from(sortList.querySelectorAll('.sortable-item')).map(item => item.dataset.id);
					hiddenInput.value = order.join(',');
				}
			});

	        const initialOrder = Array.from(sortList.querySelectorAll('.sortable-item')).map(item => item.dataset.id);
    	    hiddenInput.value = initialOrder.join(',');
    	});

		function edit_quiz_configuration(){

			var Demo_Mode = '<?php echo Demo_Mode(); ?>';
            if(Demo_Mode == 1){

				$("#dvloader").show();
				var formData = new FormData($("#edit_quiz_configuration")[0]);
				$.ajax({
					type:'POST',
					url:'{{ route("admin.quizconfiguration.update", [$result->id]) }}',
					data:formData,
					cache:false,
					contentType: false,
					processData: false,
					success:function(resp){
						$("#dvloader").hide();
						get_responce_message(resp, 'edit_quiz_configuration', '{{ route("admin.quizconfiguration.index") }}');
					},
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        $("#dvloader").hide();
                        toastr.error(errorThrown, textStatus);
                    }
				});
			} else {
                showError();
            }
		}
	</script>
@endsection